#include <PalmOS.h>

#include "Plua.h"
#include "PluaAPI.h"

// IMPORTANT: you can not use ANY global variables, or your library will CRASH.
// Instead you need to store all your "global" variables inside a C struct and
// access them through plua_setlibdata() and plua_getlibdata().

// This struct will hold the "global" variables.

typedef struct {
  UInt32 t;
} TestData;

// This is a sample function exported by this library.
// It will be registered inside PluaLibInit() below.

int lifetime(lua_State *L)
{
  PLUA_HEADER;
  TestData *g;

  // retrieve the libray global data
  g = plua_getlibdata(LIBNAME);

  lua_pushnumber(L, TimGetSeconds() - g->t);

  return 1;
}

// This is another sample function exported by this library.
// It will be registered inside PluaLibInit() below.

int square(lua_State *L)
{
  PLUA_HEADER;
  Int16 n;

  n = luaL_check_int(L, 1);
  lua_pushnumber(L, n*n);

  return 1;
}

// This function is called when the library is first loaded by a Plua program.
// You may alloc and register your gloabal data, and also register Lua
// functions with lua_register().

Err PluaLibInit(lua_State *L)
{
  PLUA_HEADER;
  TestData *g;

  // alloc the global data
  if ((g = MemPtrNew(sizeof(TestData))) == NULL)
    return -1;

  // fill the global data
  g->t = TimGetSeconds(); 

  // register the global data in Plua.
  // LIBNAME is defined in the Makefile, and must match the library name
  plua_setlibdata(LIBNAME, g);

  // register C functions in Lua
  lua_register(L, "lifetime", lifetime);
  lua_register(L, "square", square);

  // return sucess
  return 0;
}

// This function is called when the library is explicitely removed by a Plua
// program or when Plua exits, whichever happens first. You MUST unregister
// all the functions defined in PluaLibInit() and also free the global data.
// If you do not unregister a function and a Plua program calls it after
// the library is removed PalmOS will CRASH.

Err PluaLibFinish(lua_State *L)
{
  PLUA_HEADER;

  // unregister C functions in Lua
  lua_pushnil(L);
  lua_setglobal(L, "lifetime");
  lua_pushnil(L);
  lua_setglobal(L, "square");

  // free the global data
  plua_setlibdata(LIBNAME, NULL);

  // return sucess
  return 0;
}
